<?php

require("./global.php");

// set defaults
if (isset($perpage)==0 or $perpage==0) {
  $perpage=$maxthreads;
}
if (isset($pagenumber)==0 or $pagenumber==0) {
  $pagenumber=1;
}

$forumid = verifyid("forum",$forumid);

makeforumjump();

$foruminfo=$DB_site->query_first("SELECT title,description,active FROM forum WHERE forumid=$forumid");
$forumtitle=htmlspecialchars($foruminfo[title]);
if ($foruminfo[active]==0) {
  echo standarderror($bbtitle,gettemplate("error_forumclosed",0));
  exit;
}

$description=htmlspecialchars($foruminfo[description]);
$forumtitle=htmlspecialchars($foruminfo[title]);

$limitlower=($pagenumber-1)*$perpage;

$threads=$DB_site->query("SELECT threadid,title,lastpost,replycount,postusername FROM thread WHERE forumid=$forumid ORDER BY lastpost DESC LIMIT $limitlower,$perpage");
while ($thread=$DB_site->fetch_array($threads)) {

  $threadtitle=htmlspecialchars($thread[title]);
  $threadid=$thread[threadid];

  $notes=htmlspecialchars($thread[notes]);
  $replies=$thread[replycount];
  $firstposter=htmlspecialchars($thread[postusername]);
  $lastreplydate=date($dateformat,$thread[lastpost]+($timeoffset*3600));
  $lastreplytime=date($timeformat,$thread[lastpost]+($timeoffset*3600));

  $gotonew="";

  $newoldhot="folder";
  if ($lastvisitdate=="Never") {
    $newoldhot="new".$newoldhot;
  } elseif ($thread[lastpost]>$bblastvisit) {
      $newoldhot="new".$newoldhot;
      eval("\$gotonew = \"".gettemplate("forumdisplay_gotonew")."\";");
  }

  eval("\$forumdisplaybits .= \"".gettemplate("forumdisplaybit")."\";");

}

$countposts=$DB_site->query_first("SELECT COUNT(thread.threadid) AS threads FROM thread WHERE thread.forumid=$forumid $datecut");
if ($countposts[threads]>$perpage) {

  $pagenav="Page: ";

  $totalpages=$countposts[threads]/$perpage;
  if ($totalpages!=intval($totalpages)) {
    $totalpages=intval($totalpages)+1;
  }

  $curpage=0;
  while ($curpage++<$totalpages) {

    if (($curpage<$pagenumber-$pagenavpages or $curpage>$pagenumber+$pagenavpages) and $pagenavpages!=0) {
      if ($curpage==1) {
        $pagenav.=" <a href=\"forumdisplay.php?forumid=$forumid&pagenumber=$curpage".iif($perpage==$maxposts,"","&perpage=$perpage")."\">&lt;&lt; First Page</a> ... ";
      }
      if ($curpage==$totalpages) {
        $pagenav.=" ... <a href=\"forumdisplay.php?forumid=$forumid&pagenumber=$curpage".iif($perpage==$maxposts,"","&perpage=$perpage")."\">Last Page &gt;&gt;</a>";
      }
    } else {
      if ($curpage==$pagenumber) {
        $pagenav.=" $curpage";
      } else {
        $pagenav.=" <a href=\"forumdisplay.php?forumid=$forumid&pagenumber=$curpage".iif($perpage==$maxposts,"","&perpage=$perpage")."\">$curpage</a>";
      }
    }
  }
} else {
  $pagenav="";
}

eval("echo dovars(\"".gettemplate("forumdisplay")."\");");

?>